**概述**

下表概述了产品各个所需组件：

| **产品组件**                           | **版本**   | **描述说明** |
| ---------------------------------- | -------- | -------- |
| API函数编程库Sg.Laser.Framework.SgmcSDK | V1.1     | 编程使用     |
| MotionSDK\_App.compiled-library    | 1.0.7.13 | 下位机核心配置库 |



# **安装卸载**

## **一、安装要求**


**1、操作系统**

windows 10或 windows 11 操作系统，推荐 64 位操作系统。

**2、开发平台**

建议Visual Studio 2022

**3、内存**

4GB及以上

**4、磁盘空间**

12GB以上

**5、防火墙**

建议关闭

## **二、安装过程**

**1、API函数库安装步骤**

（1）打开VSVisual Studio 2022，创建新项目，选择Windows窗体应用（.NET Framework）,点击“下一步”进行创建。

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6b0f3626.png)


（2）右键解决方案中的“引用”，选择“添加引用”，点击浏览，选择API函数库：Sg.Laser.Framework.SgmcSDK.dll，进行添加。

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6be408aa.png)


3. 如此便完成了API函数库的配置。



## **三、更新安装**

| API函数库更新，将旧版本的库文件替换为新的，重新配置即可 |
| ----------------------------- |
| 下位机库更新，下位机库存储重新安装最新库，进行配置即可   |

##

## **四、卸载过程**

右键解决方案中的引用，找到API函数库，右键选择“移除”即可。

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6c7371f4.png)


# **技术说明**

## **一、快速启动**

### **（一）本例软、硬件配置**

| **硬件：**&#x31;.工智机2.显示屏（用笔记本需要准备网线）3.键鼠4.伺服 | **软件：**&#x31;.Visual Studio 20222. API库文件3.下位机工程 |
| ------------------------------------------ | ------------------------------------------------ |

### **（二）本例实验操作步骤**

**使用笔记本测试案例：**

1. 按照上述安装说明，配置好API函数库与工智机下位机工程。

2. 准备一个网线，连接笔记本与工智机的LAN1口。

3) 打开配置好的下位机工程，连接工智机并登录。

4) 如准备了伺服，将工智机EtherCat接口与伺服进行连接；如果使用虚轴，可以用下位机工程观察对应虚轴的状态，本案例使用虚轴。

**控制实验步骤**

（1）打开添加好API函数库的Visual Studio软件

（2）在Form1窗体上添加工具“Button”。
![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6d3d55fb.png)


（3）点击属性，将Text 改为：伺服使能，将（Name）改为“btn\_AxisPower”。

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6dca514e.png)


（4）回到From1界面，鼠标左键双击“伺服使能”按钮，打开程序，进入点击事件编辑。输入API函数代码：SmcEntity.Instance.Smc\_Axis\_Enable(0);

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6e518a2e.png)


（5）SmcEntity.Instance.Smc\_Axis\_Enable(0)中的“0”代表0轴，整个指令代表给0轴进行上使能操作。

（6）回到主界面，按照上述添加“伺服使能”按钮操作，再添加“连接工智机”按钮。
![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6efb3016.png)


（7）双击按钮，进入点击事件编辑，写入API函数：

SmcEntity.Instance.Smc\_Open("192.168.1.200",5000); 此函数作用是通过IP与Port与工智机进行通讯连接。

8. 点击启动，打开软件，左键单击按钮“连接工智机”，再单击伺服按钮。

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f6f7ea51f.png)


9. 完成后，观察虚轴或伺服实轴状态，可以发现已变为使能状态。

### **（三）实验注意点**

若在使用产品过程中遇到问题，可以参考此处。

**1、点击连接，连接不上工智机**

解决方法：

检测IP端口号是否设置正确：

工智机上运行软件，IP：192.168.3.1，Port:5000

电脑上运行软件，IP：192.168.1.200，Port:5000

**2、IP设置正确仍连不上**

解决方法：

（1）检查API下位机核心库文件是否安装

（2）检测工智机是否连接上

（3）下位机工程是否配置完成并登录下载到工智机中

**3、点击软件按钮报错**

检查API库文件是否引用。

## **二、示例**

此产品的示例代码和配置获取链接：<https://help.sinsegye.com.cn/>。在这里，您可以选择克隆存储库或下载包含示例的ZlP文件。

存在以下示例：

| **名称**                          | **版本**   | **描述**      |
| ------------------------------- | -------- | ----------- |
| Sg.Laser.Framework.SgmcSDK.dll  | V1.0.0.4 | API函数库文件    |
| MotionSDK\_App.compiled-library | 1.0.7.13 | 下位机核心配置库    |
| 下位机模版工程                         | 18.40    | 编程好的下位机工程案例 |



# **功能介绍**

## **一、控制器初始化**

在操作运动控制器之前，必须调用函数 Smc\_Init 为运动控制器分配资源。 同样，当程序结束对运动控制器的操作时，必须调用函数 Smc\_Close 释放运动控 制器所占用的 PC 系统资源，使得所占资源可被其它设备使用。

相关函数：

| 名称         | 功能         | 参考    |
| ---------- | ---------- | ----- |
| Smc\_Open  | 控制器连接初始化函数 | 3.1 节 |
| Smc\_Close | 控制器关闭函数    |       |

![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f70a6a6f5.png)


注意：连接控制器之前都需要对控制器的初始化，连接方式为网口。

例程 1：假设控制器 IP 为“192.168.3.1 ”端口号为“5000”，使用UDP 通讯 方式连接。

Smc\_Open(“192.168.3.1 ”, 5000);&#x20;

例程 2：断开连接。

Smc\_Close();

## **二、运动功能**

### **1.参数设置**

控制器在执行运动控制指令时，需设置轴的速度、加速度、减速度、加加速 度等参数。

相关函数：

| 名称                  | 功能            | 参考    |
| ------------------- | ------------- | ----- |
| Smc\_Set\_MoveSpeed | 设置单轴运动速度      | 3.2 节 |
| Smc\_Get\_MoveSpeed | 读取单轴运动速度      |       |
| Smc\_Set\_JogSpeed  | 设置单轴 Jog 运动速度 |       |
| Smc\_Get\_JogSpeed  | 读取单轴 Jog 运动速度 |       |

例程 1：设置零号轴 Move 运动的速度为 10mm/s，速度为 100mm/s^2，减速度为 100mm/s^2，加加速度为 1000mm/s^3：

Smc\_Set\_MoveSpeed(0,10,100,100,1000);

例程 2：读取零号轴 Move 运动的速度 vel，加速度 acc，减速度 dec，加加速度 jerk：

Smc\_Get\_MoveSpeed(0, ref double vel, ref double acc, ref double dec, ref double jerk);

例程 3：设置零号轴 Jog 运动的速度为 10mm/s，速度为 100mm/s^2，减速度为

100mm/s^2，加加速度为 1000mm/s^3：Smc\_Set\_JogSpeed(0,10,100,100,1000);

例程 4：读取零号轴 Jog 运动的速度 vel，加速度 acc，减速度 dec，加加速度 jerk：

Smc\_Get\_JogSpeed(0, ref double vel, ref double acc, ref double dec, ref double jerk);

### **2.点位运动**

点位运动包含 Jog 运动和位置运动。

(1) Jog 运动是指：Jog 运动，就是按住按键，电机一直走，弹起按键电机停止。

在 Jog 运动模式下，各轴可以独立设置目标速度、加速度、减速度、加加速 度等运动参数，能够独立运动或停止。
![](https://resource.helplook.net/docker_production/3648ne/article/IpxwYi0P/6875f7156d821.jpeg)


相关函数：

| 名称           | 功能     | 参考    |
| ------------ | ------ | ----- |
| Smc\_MoveJog | Jog 运动 | 3.3 节 |

例程 1：零号轴正向 Jog 运动。

Smc\_MoveJog(0, Forward); 例程 2：零号轴负向 Jog 运动：

Smc\_MoveJog(0, Backward);

(2) 位置运动包含相对位置运动和绝对位置运动。

相对位置运动：使轴从当前位置开始以设定的速度基础上移动一个相对距离 后准确地停止。

相关函数：

| 名称                | 功能     | 参考    |
| ----------------- | ------ | ----- |
| Smc\_MoveRelative | 相对位置运动 | 3.3 节 |

例程：使零号轴以设定的速度移动相对位置距离 10mm：

Smc\_MoveRelative(0, 10);

绝对位置运动：使轴从当前位置开始以设定的速度基础上移动绝对位置距离 后准确地停止。

相关函数：

| 名称                | 功能     | 参考    |
| ----------------- | ------ | ----- |
| Smc\_MoveAbsolute | 绝对位置运动 | 3.3 节 |

例程：使零号轴以设定的速度移动绝对位置距离 10mm：

Smc\_MoveRelative(0, 10);

### **3.回原点运动**

相关函数：

| 名称                      | 功能     | 参考    |
| ----------------------- | ------ | ----- |
| Smc\_GetHomingParameter | 获取回零参数 | 3.4 节 |
| Smc\_SetHomingParameter | 设置回零参数 | 3.4 节 |

例程 1：获取零号轴回零参数。

Smc\_GetHomingParameter(0, ref Sg\_HomingParameter parameter) ; 例程 2：设置零号轴回零参数。

Smc\_SetHomingParameter(0, Sg\_HomingParameter parameter)

| 名称                  | 参数               |                  | 参考    |
| ------------------- | ---------------- | ---------------- | ----- |
| Sg\_HomingParameter | UsingHoming      | 是否使用 Homing 回零模式 | 3.4 节 |
|                     | fHomePosition    | 原点位置             |       |
|                     | fVelocitySlow    | 慢速               |       |
|                     | fVelocityFast    | 快速               |       |
|                     | fAcceleration    | 加速度              |       |
|                     | fDeceleration    | 减速度              |       |
|                     | fJerk            | 加加速度             |       |
|                     | nHomingRefSwitch | 原点端口号            |       |
|                     | nDirection       | 回零方向             |       |
|                     | nHomingMode      | 回零模式             |       |

例程：使零号轴回原点运行。

Smc\_Home\_Move(0);

相关函数：

| 名称                     | 功能        | 参考    |
| ---------------------- | --------- | ----- |
| Smc\_Get\_Home\_Result | 获取回原点运动状态 | 3.4 节 |

例程：获取零号轴回原点运动状态。

Smc\_Get\_Home\_Result(0,ref state);

## **三、通用IO功能**

**1.通用IO控制**

用户可以使用控制器上的数字 I/O 口用于检测开关信号、传感器信号等输入 信号，或者控制继电器、电磁阀等输出设备。

控制器支持 I/O 延时翻转功能。该函数执行后， 首先输出一个与当前电平相 反的信号，延时设置的时间后，再自动翻转一次电平。

控制器支持 I/O 强制功能。该函数执行后，将强制输入\输出信号为用户设 置的强制值。通用 IO 控制相关函数：

| 名称                          | 功能             | 参考    |
| --------------------------- | -------------- | ----- |
| Smc\_IO\_WriteDO            | 设置输出口的电平状态     | 3.6 节 |
| Smc\_IO\_WriteDO\_Flash     | 设置输出口的闪烁信号     |       |
| Smc\_IO\_ReadDI             | 读取输入口的电平状态     |       |
| Smc\_IO\_SetForceSwitch\_DI | 设置输入口的强制信号     |       |
| Smc\_IO\_SetForceValue\_DI  | 设置输入口的强制值      |       |
| Smc\_IO\_SetForceSwitch\_DO | 设置输出口的强制信号     |       |
| Smc\_IO\_SetForceValue\_DO  | 设置输出口的强制值      |       |
| Smc\_IO\_GetDigitIOStatus   | 读取全部数字量 IO 状 态 |       |

例程 1：设置第零个输出口的电平状态。 Smc\_IO\_WriteDO(0, 1);

例程 2：设置第零个输出口的闪烁信号。

Smc\_IO\_WriteDO\_Flash(0, 1);

例程 3：设置第零个输入口的电平状态。 Smc\_IO\_ReadDI(0, 1);

例程 4：设置第零个输入口的强制开关。 Smc\_IO\_SetForceSwitch\_DI(0, 1);

例程 5：设置第零个设置输入口的强制值。 Smc\_IO\_SetForceValue\_DI(0, 1);

例程 6：设置第零个设置输出口的强制信号。

Smc\_IO\_SetForceSwitch\_DO(0, 1);  &#x20;

例程 7：设置第零个设置输出口的强制值。

Smc\_IO\_SetForceValue\_DO(0, 1);&#x20;

例程 8：读取全部数字量 IO 状态。

Smc\_IO\_GetDigitIOStatus(\[MarshalAs(UnmanagedType.LPStr)] StringBuilder info, int size)

## **四、CNC功能**

在数控加工中，同时控制多个运动轴进行插补运动的技术。这种技术使得在 复杂的曲线加工中，可以同时控制多个轴，以更高的效率和更精确的方式完成加 工任务。

CNC 控制相关函数：

| 名称                              | 功能          | 参考    |
| ------------------------------- | ----------- | ----- |
| Smc\_CNC\_BeginTransmit         | 开始下载        | 3.7 节 |
| Smc\_CNC\_EndTransmit           | 结束下载        |       |
| Smc\_CNC\_Transmit              | 下载 GCode    |       |
| Smc\_CNC\_ExecuteReadLine       | 上载 GCode    |       |
| Smc\_CNC\_ExecuteInterpolation  | 运行          |       |
| Smc\_CNC\_PausedInterpolation   | 暂停          |       |
| Smc\_CNC\_ContinueInterpolation | 继续          |       |
| Smc\_CNC\_StopInterpolation     | 停止          |       |
| Smc\_CNC\_Reset                 | 复位          |       |
| Smc\_CNC\_GetProcessingTime     | 获取 CNC 加工时间 |       |
| Smc\_CNC\_GetRobotType          | 获取机器人类型     |       |
| Smc\_CNC\_SetRobotType          | 设置机器人类型     |       |
| Smc\_CNC\_GetAxisMapID          | 获取轴 ID      |       |
| Sgmc\_CNC\_SetAxisMapID         | 设置轴 ID      |       |

例程1：通道零开始下载。

Smc\_CNC\_BeginTransmit(0);&#x20;

例程2：通道零结束下载。

Smc\_CNC\_EndTransmit(0);&#x20;

例程3：通道零下载 GCode。

Smc\_CNC\_Transmit (0, code); //code 表示 G 代码内容&#x20;

例程4：通道零上载 GCode。

Smc\_CNC\_ExecuteReadLine (0, code); //code 表示 G 代码内容

例程5：通道零运行。

Smc\_CNC\_ExecuteInterpolation(0);&#x20;

例程6：通道零暂停。

Smc\_CNC\_PausedInterpolation(0);&#x20;

例程7：通道零继续。

Smc\_CNC\_ContinueInterpolation(0);&#x20;

例程8：通道零停止。

Smc\_CNC\_StopInterpolation(0);&#x20;

例程9：通道零复位。

Smc\_CNC\_Reset(0);

例程10：通道零获取 CNC 加工时间。

Smc\_CNC\_GetProcessingTime(0,ref int processingTime )&#x20;

例程11：通道零获取机器人类型。

Smc\_CNC\_GetRobotType(0, ref int RobotType, ref int M\_RobotType)&#x20;

例程12：通道零设置机器人类型为 XY 型。

Smc\_CNC\_SetRobotType(0,0) //0:XY 型机器人；1：Scara 型机器人&#x20;

例程13：通道零获取轴 ID。

Smc\_CNC\_GetAxisMapID(ushort channel, ref int X, ref int Y, ref int Z, ref int A, ref int M\_X, ref int M\_Y, ref int M\_Z, ref int M\_A)

例程14：设置通道零的 X 为 0 轴，Y 为 1 轴，Z 为 2 轴，A 为 3 轴。 Sgmc\_CNC\_SetAxisMapID(0, 0,1, 2, 3)

# **函数列表**

## **一、通讯与运动参数**

### **1.通讯连接函数**

（1）short Smc\_Init(string ipAdress, int ipPort);&#x20;

功 能：控制器连接初始化函数，分配系统资源

参 数：ipAdress 指定对应与控制器的 IP 地址，默认值 127.0.0.1 ipPort 端口号，默认值 5000

返回值：0：连接成功，非 0：连接失败错误码

适用范围：全系列控制器&#x20;

例程：网口初始化设置

short iret =Smc\_Init(192.168.3.103，5000) //网口初始化

（2）short Smc\_Close()

功 能：控制器关闭函数，释放系统资源 参 数：无

返回值：错误代码

适用范围：全系列控制器

（3）Short Smc\_GetDllVersion(\[MarshalAs(UnmanagedType.LPStr)] StringBuilder info, int size)

功 能：获取控制器动态库文件版本号 参 数：info 返回库版本号

size 设置大小 返回值：错误代码

适用范围：全系列控制器

### **2.运动参数设置函数**

（1）short Smc\_Set\_MoveSpeed(ushort axis, double vel, double acc, double dec, double jerk)

功 能：设置 Move 运动的速度参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 vel 速度，单位：mm/s

acc 加速度，单位：mm/s^2

dec 减速度，单位：mm/s^2

jerk 加加速度，单位：mm/s^3

返回值：错误代码

适用范围：全系列控制器

（2）short Smc\_Get\_MoveSpeed(ushort axis, ref double vel, ref double acc, ref double dec, ref double jerk)

功 能：获取 Move 运动的速度参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

vel 速度，单位：mm/s

acc 加速度，单位：mm/s^2 dec 减速度，单位：mm/s^2

jerk 加加速度，单位：mm/s^3 返回值：错误代码

适用范围：全系列控制器

（3）short Smc\_Set\_JogSpeed(ushort axis, double vel, double acc, double dec, double jerk)

功 能：设置 Jog 运动的速度参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 vel 速度，单位：mm/s

acc 加速度，单位：mm/s^2

dec 减速度，单位：mm/s^2

jerk 加加速度，单位：mm/s^3 返回值：错误代码

适用范围：全系列控制器

（4）short Smc\_Get\_JogSpeed(ushort axis, ref double vel, ref double acc, ref double dec, ref double jerk)

功 能：获取 Jog 运动的速度参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 vel 速度，单位：mm/s

acc 加速度，单位：mm/s^2

dec 减速度，单位：mm/s^2

jerk 加加速度，单位：mm/s^3

返回值：错误代码

适用范围：全系列控制器

## **二、运动函数**

### **1.点位运动函数**

（1）short Smc\_MoveAbsolute( ushort axis, double position )&#x20;

功 能：绝对位置运动

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 position&#x20;

位置距离，单位：mm

返回值：错误代码

适用范围：全系列控制器

2. short Smc\_MoveRelative(ushort axis, double distance)&#x20;

功 能：相对位置运动

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 distance&#x20;

位置距离，单位：mm

返回值：错误代码

适用范围：全系列控制器

3. short Smc\_MoveJog(ushort axis, string type)&#x20;

功 能：Jog 运动

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

type Forward：正转，Backward：反转，Stop：停止&#x20;

返回值：错误代码

适用范围：全系列控制器

4. short Smc\_Check\_Done(ushort axis)&#x20;

功 能：检查指定轴的完成状态

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1&#x20;

返回值：错误代码

适用范围：全系列控制器

5. short Smc\_Stop(ushort axis, ushort stop\_mode)&#x20;

功 能：单轴停止

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 stop\_mode

返回值：错误代码

适用范围：全系列控制器

6. short Smc\_Emg\_Stop() &#x20;

功 能：紧急停止所有轴

参数：无

返回值：错误代码

适用范围：全系列控制器

### **2.回原点运动函数**

（1）short Smc\_Home\_Move(ushort axis)&#x20;

功 能：回原点运动

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

返回值：错误代码

适用范围：全系列控制器

2. short Smc\_Get\_Home\_Result(ushort axis, ref ushort state)&#x20;

功 能：获取回原点运动状态

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

state 返回回原点运动状态，0：末完成，1：完成&#x20;

返回值：错误代码

适用范围：全系列控制器

3. Smc\_GetHomingParameter(ushort axis, ref Sg\_HomingParameter parameter)&#x20;

功 能：获取回零参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 parameter 返回回原点的具体参数，

UsingHoming：是否使用 Homing 回零模式 fHomePosition：原点位置

fVelocitySlow：慢速 fVelocityFast：快速  fAcceleration：加速度 fDeceleration：减速度    fJerk：加加速度

nHomingRefSwitch：原点端口号

nDirection：回零方向     nHomingMode：回零模式&#x20;

返回值：错误代码

适用范围：全系列控制器

4. Smc\_SetHomingParameter(ushort axis, Sg\_HomingParameter parameter)&#x20;

功 能：设置回零参数

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 parameter 返回回原点的具体参数，

UsingHoming：是否使用 Homing 回零模式 fHomePosition：原点位置

fVelocitySlow：慢速 fVelocityFast：快速  fAcceleration：加速度

fDeceleration：减速度    fJerk：加加速度

nHomingRefSwitch：原点端口号

nDirection：回零方向     nHomingMode：回零模式&#x20;

返回值：错误代码

适用范围：全系列控制器

### **3.状态监控函数**

（1）short Smc\_GetAxisState(\[MarshalAs(UnmanagedType.LPStr)] StringBuilder axisState, int size)

功 能：获取指定轴有关运动信号的状态

参 数：axisState 返回轴有关运动信号的状态 size 设置大小

返回值：错误代码

适用范围：全系列控制器

2. short Smc\_Get\_PowerStatus(ushort axis, ref ushort state)&#x20;

功 能：获取指定轴使能状态

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

state 返回使能状态，0：未使能，1：使能&#x20;

返回值：错误代码

适用范围：全系列控制器

3. short Smc\_Set\_Position(ushort axis, double pos)&#x20;

功 能：设置指定轴当前位置

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

pos 位置，单位：mm&#x20;

返回值：错误代码

适用范围：全系列控制器

4. short Smc\_Get\_ActPosition(ushort axis, ref double pos)&#x20;

功 能：获取指定轴实际位置

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 pos 返回实际位置，单位：mm

返回值：错误代码

适用范围：全系列控制器

5. short Smc\_Get\_TargetPosition(ushort axis, ref double pos)&#x20;

功 能：获取指定轴规划位置

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 pos 返回规划位置，单位：mm

返回值：错误代码

适用范围：全系列控制器

6. short Smc\_Get\_ActVelocity(ushort axis, ref double speed)&#x20;

功 能：获取指定轴实际速度

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1

speed 返回实际速度，单位：mm/s&#x20;

返回值：错误代码

适用范围：全系列控制器

7. short Smc\_Get\_ActAcceleration(ushort axis, ref double actacc)&#x20;

功 能：获取指定轴实际加速度

参 数：axis 轴号，取值范围：0\~控制器最大轴数-1 actacc 返回实际加速度，单位：mm/s^2

返回值：错误代码

适用范围：全系列控制器

## **三、IO函数**

### **1.通用IO接口函数**

（1）int Smc\_IO\_ReadDO(ushort bitno, ref ushort on\_off);&#x20;

功 能：读取指定输出端口信号状态

参 数：bitno 输出端口号，取值范围：0\~控制器本机输出口数-1

on\_off 输出端口信号，0：低电平，1：高电平&#x20;

返回值：错误代码

适用范围：全系列控制器

2. short Smc\_IO\_WriteDO(ushort bitno, ushort on\_off)&#x20;

功 能：设置指定输出端口信号

参 数：bitno 输出端口号，取值范围：0\~控制器本机输出口数-1 on\_off 输出端口信号，0：低电平，1：高电平

返回值：错误代码

适用范围：全系列控制器

3. short Smc\_IO\_WriteDO\_Flash(ushort bitno, ushort on\_off)&#x20;

功 能：设置指定输出端口闪烁信号

参 数：bitno 输出端口号，取值范围：0\~控制器本机输出口数-1

on\_off 输出端口信号&#x20;

返回值：错误代码

适用范围：全系列控制器

4. short Smc\_IO\_ReadDI(ushort bitno, ref ushort on\_off)&#x20;

功 能：获取输入端口信号

参 数：bitno 输入端口号，取值范围：0\~控制器本机输出口数-1

on\_off 返回输入端口信号&#x20;

返回值：错误代码

适用范围：全系列控制器

5. short Smc\_IO\_SetForceSwitch\_DI(ushort bitno, ushort on\_off)&#x20;

功 能：设置输入端口强制信号

参 数：bitno 输入端口号，取值范围：0\~控制器本机输出口数-1 on\_off 输入端口强制信号

返回值：错误代码

适用范围：全系列控制器

6. short Smc\_IO\_SetForceValue\_DI(ushort bitno, ushort on\_off)&#x20;

功 能：设置输入端口强制值

参 数：bitno 输入端口号，取值范围：0\~控制器本机输出口数-1 on\_off 输入端口强制值

返回值：错误代码

适用范围：全系列控制器

7. short Smc\_IO\_SetForceSwitch\_DO(ushort bitno, ushort on\_off)&#x20;

功 能：设置输出端口强制信号

参 数：bitno 输出端口号，取值范围：0\~控制器本机输出口数-1 on\_off 输出端口强制信号

返回值：错误代码

适用范围：全系列控制器

8. short Smc\_IO\_SetForceValue\_DO(ushort bitno, ushort on\_off)&#x20;

功 能：设置输出端口强制信号

参 数：bitno 输出端口号，取值范围：0\~控制器本机输出口数-1 on\_off 输出端口强制值

返回值：错误代码

适用范围：全系列控制器

9. short Smc\_IO\_GetDigitIOStatus(\[MarshalAs(UnmanagedType.LPStr)]StringBuilder info, int size)&#x20;

功 能：获取数字量 IO 的状态

参 数：info 返回 IO 状态size 设置大小&#x20;

返回值：错误代码

适用范围：全系列控制器

### **2.模拟量IO接口函数**

（1）int Smc\_IO\_ReadAO(ushort bitno, ref double value);&#x20;

功 能：读模拟量输出

参 数：bitno IO 点    Value 模拟量电压值

返回值：错误代码

适用范围：全系列控制器

（2）int Smc\_IO\_WriteAO (ushort bitno, double value);

功 能：写模拟量输出&#x20;

参 数：bitno IO 点     Value 模拟量输出电压值&#x20;

返回值：错误代码

适用范围：全系列控制器

（3）int Smc\_IO\_SetForceSwitch\_AO(ushort bitno, ushort on\_off);

功 能：设置模拟量强制输出开关&#x20;

参 数：bitno 强制 IO 点

on\_off 强制允许信号&#x20;

返回值：错误代码

适用范围：全系列控制器

（4）int Smc\_IO\_SetForceValue\_AO(ushort bitno, double value);

功 能：设置模拟量强制输出值&#x20;

参 数：bitno 强制 IO 点

Value 强制值&#x20;

返回值：错误代码

适用范围：全系列控制器

### **3.特殊IO功能**

（1）int MoveAbsoluteAndMemOutIO(int axisID, float position, int percent, int port);

功 能：绝对运动同步输出内存信号&#x20;

参 数：axisID 轴号

position 目标位置

percent 触发信号的运动路径比例

port 触发内存信号的端口&#x20;

返回值：错误代码

适用范围：全系列控制器

（2）int Smc\_IO\_WriteMemIO(ushort bitno, ushort on\_off);&#x20;

功 能：写内存位 IO

参 数：bitno IO 端口号 on\_off 开关

注意事项：该信号在运动触发后可以操作&#x20;

返回值：错误代码

适用范围：全系列控制器

（3）int Smc\_IO\_ReadMemIO(ushort bitno, ref ushort on\_off);&#x20;

功 能：读内存位 IO

参 数：bitno IO 端口号 on\_off 信号状态

注意事项：该信号在运动触发后可以操作&#x20;

返回值：错误代码

适用范围：全系列控制器

（4）int Smc\_IO\_WriteDO\_PWM(ushort bitno, ushort on\_off, int frequency, int dutyfactor);

功 能：写 PWM 信号

参 数：bitno PWM 类型 IO 端口号 on\_off 打开或关闭

frequency 脉宽信号周期 dutyfactor 占空比

返回值：错误代码

适用范围：全系列控制器

（5）int Smc\_IO\_WriteDO\_PSO(ushort bitno, ushort on\_off, int OutputDelay, float StartPos, float TrigDist, int PSO\_AxisNum);

功 能：写 PSO 信号

参 数：bitno PSO 类型 IO 端口号 on\_off 打开或关闭

OutputDelay 信号打开后的持续时间 StartPos 触发信号的开始位置

TrigDist 触发距离设置

PSO\_AxisNum PSO 信号参与轴数量设置,设置范围 1-3。设置为 1 时，开 始位置与触发距离都只与下位机参数中配置对应的第一个轴相关

返回值：错误代码

适用范围：全系列控制器

## **四、限位函数与CNC函数**

### **1.软限位**

（1）int Smc\_SetSoftwareLimits(int axisID, double limitPositive, double limitNegative);

功 能：设置软件限位

参 数：axisID 轴号

limitPositive 正限位 limitNegative 负限位

返回值：错误代码

适用范围：全系列控制器

（2）int Smc\_ActivateSoftwareLimits(int axisID, ushort bActivate);&#x20;

功 能：激活软件限位

参 数：axisID 轴号

bActivate 是否激活&#x20;

返回值：错误代码

适用范围：全系列控制器

（3）int Smc\_GetSoftwareLimits(int axisID, ref ushort bActivate, ref double limitPositive, ref double limitNegative);

功 能：获取软件限位

参 数：axisID 轴号

bActivate 是否激活

limitPositive 正限位 limitNegative 负限位

返回值：错误代码

适用范围：全系列控制器

### **2.CNC控制相关函数**

（1）Smc\_CNC\_BeginTransmit(ushort channel)

功 能：开始下载 GCode&#x20;

参 数：channel 通道 &#x20;

返回值：错误代码

适用范围：全系列控制器

（2）Smc\_CNC\_EndTransmit(ushort channel)&#x20;

功 能：结束下载 GCode

参 数：channel 通道

返回值：错误代码

适用范围：全系列控制器

（3）Smc\_CNC\_Transmit(ushort channel, string code)&#x20;

功 能：下载 GCode

参 数：channel 通道

code G 代码内容&#x20;

返回值：错误代码

适用范围：全系列控制器

（4）Smc\_CNC\_ExecuteReadLine(ushort channel, ref string code)&#x20;

功 能：上载 GCode

参 数：channel 通道   code G 代码内容

返回值：错误代码

适用范围：全系列控制器

（5）Smc\_CNC\_ExecuteInterpolation(ushort channel)&#x20;

功 能：运行 GCode

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（6）Smc\_CNC\_ExecuteInterpolation(ushort channel)&#x20;

功 能：运行 GCode

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（7）Smc\_CNC\_PausedInterpolation(ushort channel)&#x20;

功 能：暂停运行 GCode

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（8）Smc\_CNC\_ContinueInterpolation(ushort channel)&#x20;

功 能：继续运行 GCode

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（9）Smc\_CNC\_StopInterpolation(ushort channel)&#x20;

功 能：停止运行 GCode

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（9）Smc\_CNC\_Reset(ushort channel)&#x20;

功 能：复位

参 数：channel 通道&#x20;

返回值：错误代码

适用范围：全系列控制器

（10）Smc\_GetCardStatus(ref Sg\_CardStatus cardStatus, ref Sg\_CNC\_State cncstatus0, ref Sg\_CNC\_State cncstatus1)

功 能：获取板卡状态

参 数：cardStatus 板卡状态，cncstatus0 CNC0 状态，cncstatus1 CNC1 状态&#x20;

返回值：错误代码

适用范围：全系列控制器

（11）Smc\_CNC\_GetProcessingTime(ushort channel, ref int processingTime)&#x20;

功 能：获取 CNC 加工时间

参 数：channel 通道，processingTime 加工时间&#x20;

返回值：错误代码

适用范围：全系列控制器

（12）Smc\_CNC\_GetRobotType(ushort  channel,  ref  int  RobotType,  ref  int

M\_RobotType)

功 能：获取机器人类型

参 数：channel 通道，RobotType，M\_RobotType：机器人类型&#x20;

返回值：错误代码

适用范围：全系列控制器

（13）Smc\_CNC\_ SetRobotType(ushort channel, int RobotType)&#x20;

功 能：获取机器人类型

参 数：channel 通道，RobotType：机器人类型&#x20;

返回值：错误代码

适用范围：全系列控制器

（14）Smc\_CNC\_GetAxisMapID(ushort channel, ref int, ref int Y, ref int Z, ref int A, ref int M\_X, ref int M\_Y, ref int M\_Z, ref int M\_A)

功 能：获取机器人类型

参 数：channel 通道     轴号：X、Y、Z、A、M\_X、M\_Y、M\_Z、M\_A

返回值：错误代码

适用范围：全系列控制器

（15）Sgmc\_CNC\_SetAxisMapID(ushort channel, int X, int Y, int Z, int A)&#x20;

功 能：获取机器人类型

参 数：channel 通道， 轴号：X,Y,Z,A

返回值：错误代码

适用范围：全系列控制器

### **3.其他类函数**

（1）Smc\_GetEncoderIn(ushort  channel,  ref   int  outvalue,  ref  double

realvalue)

功 能：获取外部编码器的值&#x20;

参 数：channel 通道，

outvalue：实际输出值 ，realvalue：offset 内部输出值&#x20;

返回值：错误代码

适用范围：全系列控制器

（2）Smc\_SetEncoderOffset(ushort channel, int pos)&#x20;

功 能：设置外部编码器的值 &#x20;

返回值：错误代码

参 数：channel 通道，pos：位置 &#x20;

适用范围：全系列控制器